/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_6908;
import net.minecraft.class_6910;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.generator.BCLBiomeSource;
import org.betterx.bclib.api.v2.generator.BiomeDecider;
import org.betterx.bclib.api.v2.generator.BiomePicker;
import org.betterx.bclib.api.v2.generator.TheEndBiomesHelper;
import org.betterx.bclib.api.v2.generator.config.BCLEndBiomeSourceConfig;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.InternalBiomeAPI;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.interfaces.BiomeMap;
import org.betterx.worlds.together.biomesource.BiomeSourceWithConfig;
import org.betterx.worlds.together.biomesource.ReloadableBiomeSource;
import org.jetbrains.annotations.NotNull;

public class BCLibEndBiomeSource
extends BCLBiomeSource
implements BiomeSourceWithConfig<BCLibEndBiomeSource, BCLEndBiomeSourceConfig>,
ReloadableBiomeSource {
    public static Codec<BCLibEndBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6903.method_40419((class_5321)class_2378.field_25114).forGetter(theEndBiomeSource -> theEndBiomeSource.biomeRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(source -> source.currentSeed), (App)BCLEndBiomeSourceConfig.CODEC.fieldOf("config").orElse((Object)BCLEndBiomeSourceConfig.DEFAULT).forGetter(o -> o.config)).apply((Applicative)instance, instance.stable(BCLibEndBiomeSource::new)));
    private final Point pos;
    private BiomeMap mapLand;
    private BiomeMap mapVoid;
    private BiomeMap mapCenter;
    private BiomeMap mapBarrens;
    private BiomePicker endLandBiomePicker;
    private BiomePicker endVoidBiomePicker;
    private BiomePicker endCenterBiomePicker;
    private BiomePicker endBarrensBiomePicker;
    private List<BiomeDecider> deciders;
    private BCLEndBiomeSourceConfig config;

    public BCLibEndBiomeSource(class_2378<class_1959> biomeRegistry, long seed, BCLEndBiomeSourceConfig config) {
        this(biomeRegistry, seed, config, true);
    }

    public BCLibEndBiomeSource(class_2378<class_1959> biomeRegistry, BCLEndBiomeSourceConfig config) {
        this(biomeRegistry, 0L, config, false);
    }

    private BCLibEndBiomeSource(class_2378<class_1959> biomeRegistry, long seed, BCLEndBiomeSourceConfig config, boolean initMaps) {
        this(biomeRegistry, BCLibEndBiomeSource.getBiomes(biomeRegistry), seed, config, initMaps);
    }

    private BCLibEndBiomeSource(class_2378<class_1959> biomeRegistry, List<class_6880<class_1959>> list, long seed, BCLEndBiomeSourceConfig config, boolean initMaps) {
        super(biomeRegistry, list, seed);
        this.config = config;
        this.rebuildBiomePickers();
        this.pos = new Point();
        if (initMaps) {
            this.initMap(seed);
        }
    }

    @NotNull
    private void rebuildBiomePickers() {
        Map<BiomeAPI.BiomeType, List<String>> includeMap = Configs.BIOMES_CONFIG.getBiomeIncludeMap();
        List<String> excludeList = Configs.BIOMES_CONFIG.getExcludeMatching(BiomeAPI.BiomeType.END);
        this.deciders = BiomeDecider.DECIDERS.stream().filter(d -> d.canProvideFor(this)).map(d -> d.createInstance(this)).toList();
        this.endLandBiomePicker = new BiomePicker((class_2378<class_1959>)this.biomeRegistry);
        this.endVoidBiomePicker = new BiomePicker((class_2378<class_1959>)this.biomeRegistry);
        this.endCenterBiomePicker = new BiomePicker((class_2378<class_1959>)this.biomeRegistry);
        this.endBarrensBiomePicker = new BiomePicker((class_2378<class_1959>)this.biomeRegistry);
        HashMap<BiomeAPI.BiomeType, BiomePicker> pickerMap = new HashMap<BiomeAPI.BiomeType, BiomePicker>();
        pickerMap.put(BiomeAPI.BiomeType.END_LAND, this.endLandBiomePicker);
        pickerMap.put(BiomeAPI.BiomeType.END_VOID, this.endVoidBiomePicker);
        pickerMap.put(BiomeAPI.BiomeType.END_CENTER, this.endCenterBiomePicker);
        pickerMap.put(BiomeAPI.BiomeType.END_BARRENS, this.endBarrensBiomePicker);
        this.method_28443().forEach(biome -> {
            BCLBiome bclBiome;
            class_5321 key = (class_5321)biome.method_40230().orElseThrow();
            class_2960 biomeID = key.method_29177();
            String biomeStr = biomeID.toString();
            if (excludeList != null && excludeList.contains(biomeStr)) {
                return;
            }
            if (!biome.method_40227()) {
                BCLib.LOGGER.warning("Biome " + biomeStr + " is requested but not yet bound.", new Object[0]);
                return;
            }
            if (!BiomeAPI.hasBiome(biomeID)) {
                bclBiome = new BCLBiome(biomeID, (class_1959)biome.comp_349(), BiomeAPI.BiomeType.END_LAND);
                InternalBiomeAPI.registerBCLBiomeData(bclBiome);
            } else {
                bclBiome = BiomeAPI.getBiome(biomeID);
            }
            if ((bclBiome != null || bclBiome != BCLBiomeRegistry.EMPTY_BIOME) && bclBiome.getParentBiome() == null) {
                if (!this.config.withVoidBiomes && biomeID.equals((Object)class_1972.field_9457.method_29177())) {
                    return;
                }
                boolean didForceAdd = false;
                for (Map.Entry entry : pickerMap.entrySet()) {
                    List includeList = includeMap == null ? null : (List)includeMap.get(entry.getKey());
                    if (includeList == null || !includeList.contains(biomeStr)) continue;
                    ((BiomePicker)entry.getValue()).addBiome(bclBiome);
                    didForceAdd = true;
                }
                if (!(didForceAdd || biomeID.equals((Object)BCLBiomeRegistry.EMPTY_BIOME.getID()) || bclBiome.getIntendedType().is(BiomeAPI.BiomeType.END_IGNORE))) {
                    didForceAdd = false;
                    for (BiomeDecider decider : this.deciders) {
                        if (!decider.addToPicker(bclBiome)) continue;
                        didForceAdd = true;
                        break;
                    }
                    if (!didForceAdd) {
                        if (bclBiome.getIntendedType().is(BiomeAPI.BiomeType.END_CENTER) || TheEndBiomesHelper.canGenerateAsMainIslandBiome((class_5321<class_1959>)key)) {
                            this.endCenterBiomePicker.addBiome(bclBiome);
                        } else if (bclBiome.getIntendedType().is(BiomeAPI.BiomeType.END_LAND) || TheEndBiomesHelper.canGenerateAsHighlandsBiome((class_5321<class_1959>)key)) {
                            if (!this.config.withVoidBiomes) {
                                this.endVoidBiomePicker.addBiome(bclBiome);
                            }
                            this.endLandBiomePicker.addBiome(bclBiome);
                        } else if (bclBiome.getIntendedType().is(BiomeAPI.BiomeType.END_BARRENS) || TheEndBiomesHelper.canGenerateAsEndBarrens((class_5321<class_1959>)key)) {
                            this.endBarrensBiomePicker.addBiome(bclBiome);
                        } else if (bclBiome.getIntendedType().is(BiomeAPI.BiomeType.END_VOID) || TheEndBiomesHelper.canGenerateAsSmallIslandsBiome((class_5321<class_1959>)key)) {
                            this.endVoidBiomePicker.addBiome(bclBiome);
                        } else {
                            if (Configs.MAIN_CONFIG.verboseLogging()) {
                                BCLib.LOGGER.info("Found End Biome " + biomeStr + " that was not registers with fabric or bclib. Assuming end-land Biome...");
                            }
                            this.endLandBiomePicker.addBiome(bclBiome);
                        }
                    }
                }
            }
        });
        this.endLandBiomePicker.rebuild();
        this.endVoidBiomePicker.rebuild();
        this.endBarrensBiomePicker.rebuild();
        this.endCenterBiomePicker.rebuild();
        for (BiomeDecider decider : this.deciders) {
            decider.rebuild();
        }
        if (this.endVoidBiomePicker.isEmpty()) {
            BCLib.LOGGER.info("No Void Biomes found. Disabling by using barrens");
            this.endVoidBiomePicker = this.endBarrensBiomePicker;
        }
        if (this.endBarrensBiomePicker.isEmpty()) {
            BCLib.LOGGER.info("No Barrens Biomes found. Disabling by using land Biomes");
            this.endBarrensBiomePicker = this.endLandBiomePicker;
            this.endVoidBiomePicker = this.endLandBiomePicker;
        }
        if (this.endCenterBiomePicker.isEmpty()) {
            BCLib.LOGGER.warning("No Center Island Biomes found. Forcing use of vanilla center.", new Object[0]);
            this.endCenterBiomePicker.addBiome(BiomeAPI.THE_END);
            this.endCenterBiomePicker.rebuild();
            if (this.endCenterBiomePicker.isEmpty()) {
                BCLib.LOGGER.error("Unable to force vanilla central Island. Falling back to land Biomes...");
                this.endCenterBiomePicker = this.endLandBiomePicker;
            }
        }
    }

    @Override
    protected BCLBiomeSource cloneForDatapack(Set<class_6880<class_1959>> datapackBiomes) {
        datapackBiomes.addAll(BCLibEndBiomeSource.getNonVanillaBiomes((class_2378<class_1959>)this.biomeRegistry));
        datapackBiomes.addAll(this.method_28443().stream().filter(h -> !((class_5321)h.method_40230().orElseThrow()).method_29177().method_12836().equals("minecraft")).toList());
        return new BCLibEndBiomeSource((class_2378<class_1959>)this.biomeRegistry, datapackBiomes.stream().filter(b -> b.method_40222(this.biomeRegistry) && b.method_40230().orElse(null) != BCLBiomeRegistry.EMPTY_BIOME.getBiomeKey()).toList(), this.currentSeed, this.config, true);
    }

    private static List<class_6880<class_1959>> getNonVanillaBiomes(class_2378<class_1959> biomeRegistry) {
        return BCLibEndBiomeSource.getBiomes(biomeRegistry, Configs.BIOMES_CONFIG.getExcludeMatching(BiomeAPI.BiomeType.END), Configs.BIOMES_CONFIG.getIncludeMatching(BiomeAPI.BiomeType.END), BCLibEndBiomeSource::isValidNonVanillaEndBiome);
    }

    private static List<class_6880<class_1959>> getBiomes(class_2378<class_1959> biomeRegistry) {
        return BCLibEndBiomeSource.getBiomes(biomeRegistry, Configs.BIOMES_CONFIG.getExcludeMatching(BiomeAPI.BiomeType.END), Configs.BIOMES_CONFIG.getIncludeMatching(BiomeAPI.BiomeType.END), BCLibEndBiomeSource::isValidEndBiome);
    }

    private static boolean isValidEndBiome(class_6880<class_1959> biome, class_2960 location) {
        if (BiomeAPI.wasRegisteredAs(location, BiomeAPI.BiomeType.END_IGNORE)) {
            return false;
        }
        return biome.method_40220(class_6908.field_37394) || BiomeAPI.wasRegisteredAsEndBiome(location) || TheEndBiomesHelper.canGenerateInEnd((class_5321<class_1959>)((class_5321)biome.method_40230().orElse(null)));
    }

    private static boolean isValidNonVanillaEndBiome(class_6880<class_1959> biome, class_2960 location) {
        if (BiomeAPI.wasRegisteredAs(location, BiomeAPI.BiomeType.END_IGNORE) || ((class_5321)biome.method_40230().orElseThrow()).method_29177().method_12836().equals("minecraft")) {
            return false;
        }
        return biome.method_40220(class_6908.field_37394) || BiomeAPI.wasRegisteredAsEndBiome(location) || TheEndBiomesHelper.canGenerateInEnd((class_5321<class_1959>)((class_5321)biome.method_40230().orElse(null)));
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)BCLib.makeID("end_biome_source"), CODEC);
    }

    @Override
    protected void onInitMap(long seed) {
        for (BiomeDecider decider : this.deciders) {
            decider.createMap((picker, size) -> this.config.mapVersion.mapBuilder.create(seed, size <= 0 ? this.config.landBiomesSize : size, picker));
        }
        this.mapLand = this.config.mapVersion.mapBuilder.create(seed, this.config.landBiomesSize, this.endLandBiomePicker);
        this.mapVoid = this.config.mapVersion.mapBuilder.create(seed, this.config.voidBiomesSize, this.endVoidBiomePicker);
        this.mapCenter = this.config.mapVersion.mapBuilder.create(seed, this.config.centerBiomesSize, this.endCenterBiomePicker);
        this.mapBarrens = this.config.mapVersion.mapBuilder.create(seed, this.config.barrensBiomesSize, this.endBarrensBiomePicker);
    }

    @Override
    protected void onHeightChange(int newHeight) {
    }

    public class_6880<class_1959> method_38109(int biomeX, int biomeY, int biomeZ, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_6544.class_6552 sampler) {
        long dist;
        if (this.mapLand == null || this.mapVoid == null || this.mapCenter == null || this.mapBarrens == null) {
            return (class_6880)this.method_28443().stream().findFirst().orElseThrow();
        }
        int posX = class_5742.method_33101((int)biomeX);
        int posY = class_5742.method_33101((int)biomeY);
        int posZ = class_5742.method_33101((int)biomeZ);
        long l = dist = (long)(Math.abs(posX) + Math.abs(posZ)) > (long)this.config.innerVoidRadiusSquared ? (long)this.config.innerVoidRadiusSquared + 1L : (long)posX * (long)posX + (long)posZ * (long)posZ;
        if ((biomeX & 0x3F) == 0 || (biomeZ & 0x3F) == 0) {
            this.mapLand.clearCache();
            this.mapVoid.clearCache();
            this.mapCenter.clearCache();
            this.mapVoid.clearCache();
            for (BiomeDecider decider : this.deciders) {
                decider.clearMapCache();
            }
        }
        int x = (class_4076.method_18675((int)posX) * 2 + 1) * 8;
        int z = (class_4076.method_18675((int)posZ) * 2 + 1) * 8;
        double d = sampler.comp_367().method_40464((class_6910.class_6912)new class_6910.class_6914(x, posY, z));
        BiomeAPI.BiomeType suggestedType = dist <= (long)this.config.innerVoidRadiusSquared ? BiomeAPI.BiomeType.END_CENTER : (d > 0.25 ? BiomeAPI.BiomeType.END_LAND : (d >= -0.0625 ? BiomeAPI.BiomeType.END_LAND : (d < -0.21875 ? BiomeAPI.BiomeType.END_VOID : (this.config.withVoidBiomes ? BiomeAPI.BiomeType.END_BARRENS : BiomeAPI.BiomeType.END_LAND))));
        BiomeAPI.BiomeType originalType = suggestedType;
        for (BiomeDecider decider : this.deciders) {
            suggestedType = decider.suggestType(originalType, suggestedType, d, this.maxHeight, posX, posY, posZ, biomeX, biomeY, biomeZ);
        }
        for (BiomeDecider decider : this.deciders) {
            BiomePicker.ActualBiome result;
            if (!decider.canProvideBiome(suggestedType) || (result = decider.provideBiome(suggestedType, posX, posY, posZ)) == null) continue;
            return result.biome;
        }
        if (suggestedType.is(BiomeAPI.BiomeType.END_CENTER)) {
            return this.mapCenter.getBiome((double)((double)posX), (double)((double)posY), (double)((double)posZ)).biome;
        }
        if (suggestedType.is(BiomeAPI.BiomeType.END_VOID)) {
            return this.mapVoid.getBiome((double)((double)posX), (double)((double)posY), (double)((double)posZ)).biome;
        }
        if (suggestedType.is(BiomeAPI.BiomeType.END_BARRENS)) {
            return this.mapBarrens.getBiome((double)((double)posX), (double)((double)posY), (double)((double)posZ)).biome;
        }
        return this.mapLand.getBiome((double)((double)posX), (double)((double)posY), (double)((double)posZ)).biome;
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    public String toString() {
        return "\nBCLib - The End BiomeSource (" + Integer.toHexString(this.hashCode()) + ")\n    biomes     = " + this.method_28443().size() + "\n    namespaces = " + this.getNamespaces() + "\n    seed       = " + this.currentSeed + "\n    height     = " + this.maxHeight + "\n    deciders   = " + this.deciders.size() + "\n    config     = " + this.config;
    }

    @Override
    public BCLEndBiomeSourceConfig getTogetherConfig() {
        return this.config;
    }

    @Override
    public void setTogetherConfig(BCLEndBiomeSourceConfig newConfig) {
        this.config = newConfig;
        this.initMap(this.currentSeed);
    }

    @Override
    public void reloadBiomes() {
        this.rebuildBiomePickers();
        this.initMap(this.currentSeed);
    }
}

